/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.item.ItemCustom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class ObjectLists {
    public static String[] itemListNames = new String[]{"RawMeat", "CookedMeat", "Vegetables", "RawFish", "CookedFish", "CactusFood", "Mushrooms", "Sweets", "Fuel"};
    public static Map<String, List<ItemStack>> itemLists = new HashMap<String, List<ItemStack>>();
    public static Map<String, List<Class>> entityLists = new HashMap<String, List<Class>>();
    public static Map<String, List<Potion>> effectLists = new HashMap<String, List<Potion>>();
    public static Map<String, Potion> allEffects = new HashMap<String, Potion>();

    public static void addItem(String list, Object object) {
        if (!(object instanceof Item || object instanceof Block || object instanceof ItemStack || object instanceof String)) {
            return;
        }
        if (!itemLists.containsKey(list = list.toLowerCase())) {
            itemLists.put(list, new ArrayList());
        }
        ItemStack itemStack = null;
        if (object instanceof Item) {
            itemStack = new ItemStack((Item)object);
        } else if (object instanceof Block) {
            itemStack = new ItemStack((Block)object);
        } else if (object instanceof ItemStack) {
            itemStack = (ItemStack)object;
        } else if (object instanceof String) {
            if (ObjectManager.getItem((String)object) != null) {
                itemStack = new ItemStack(ObjectManager.getItem((String)object));
            } else if (ObjectManager.getBlock((String)object) != null) {
                itemStack = new ItemStack(ObjectManager.getBlock((String)object));
            }
        }
        if (itemStack != null) {
            itemLists.get(list).add(itemStack);
        }
    }

    public static void addEntity(String list, Object object) {
        CreatureInfo creatureInfo;
        if (!(object instanceof Entity) && !(object instanceof String)) {
            return;
        }
        if (!entityLists.containsKey(list = list.toLowerCase())) {
            entityLists.put(list, new ArrayList());
        }
        Class<? extends EntityLiving> entity = null;
        if (object instanceof String && (creatureInfo = CreatureManager.getInstance().getCreature((String)object)) != null) {
            entity = creatureInfo.entityClass;
        }
        if (entity != null) {
            entityLists.get(list).add(entity);
        }
    }

    public static void addEffect(String list, Potion effect, String effectName) {
        if (effect == null) {
            return;
        }
        allEffects.put(effectName, effect);
        list = list.toLowerCase();
        if (!effectLists.containsKey(list)) {
            effectLists.put(list, new ArrayList());
        }
        effectLists.get(list).add(effect);
    }

    public static ItemStack[] getItems(String list) {
        if (!itemLists.containsKey(list = list.toLowerCase())) {
            return new ItemStack[0];
        }
        return itemLists.get(list).toArray(new ItemStack[itemLists.get(list).size()]);
    }

    public static Class[] getEntites(String list) {
        if (!entityLists.containsKey(list = list.toLowerCase())) {
            return new Class[0];
        }
        return entityLists.get(list).toArray(new Class[entityLists.get(list).size()]);
    }

    public static Potion[] getEffects(String list) {
        if (!effectLists.containsKey(list = list.toLowerCase())) {
            return new Potion[0];
        }
        return effectLists.get(list).toArray(new Potion[effectLists.get(list).size()]);
    }

    public static boolean inItemList(String list, ItemStack testStack) {
        list = list.toLowerCase();
        if (testStack.func_190926_b()) {
            return false;
        }
        testStack.func_77973_b();
        if (!itemLists.containsKey(list)) {
            return false;
        }
        for (ItemStack listStack : itemLists.get(list)) {
            if (testStack.func_77973_b() != listStack.func_77973_b() || testStack.func_77952_i() != listStack.func_77952_i()) continue;
            return true;
        }
        return false;
    }

    public static boolean inEntityList(String list, Class testClass) {
        if (!entityLists.containsKey(list = list.toLowerCase())) {
            return false;
        }
        return false;
    }

    public static boolean inEffectList(String list, Potion testPotion) {
        if (!effectLists.containsKey(list = list.toLowerCase())) {
            return false;
        }
        return effectLists.get(list).contains(testPotion);
    }

    public static boolean isInOreDictionary(String oreEntry, Item item) {
        return ObjectLists.isInOreDictionary(oreEntry, new ItemStack(item));
    }

    public static boolean isInOreDictionary(String oreEntry, Block block) {
        return ObjectLists.isInOreDictionary(oreEntry, new ItemStack(block));
    }

    public static boolean isInOreDictionary(String oreEntry, ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        NonNullList ores = OreDictionary.getOres((String)oreEntry);
        if (ores == null) {
            return false;
        }
        for (ItemStack ore : ores) {
            if (ore.func_77973_b() != itemStack.func_77973_b()) continue;
            return true;
        }
        return false;
    }

    public static void createCustomItems() {
        ConfigBase config = ConfigBase.getConfig(LycanitesMobs.modInfo, "itemlists");
        config.setCategoryComment("Custom Objects", "here you can add your own custom items! These items wont do anything and will have no crafting recipes you can however have them drop from mobs by adding them to the custom mob drops. To add items just create a comma seperated list of names (spaces will be removed), you will need to use the item.youritem.name and item.youritem.description lang file entries in your resource pack to name your item and you will also need to save a texture for your item as: assets/lycanitesmobs/items/youritem.png");
        String customItems = config.getString("Custom Objects", "Custom Items", "");
        if ("".equals(customItems)) {
            return;
        }
        for (String itemEntry : customItems.replace(" ", "").split(",")) {
            ObjectManager.addItem(itemEntry, new ItemCustom(itemEntry, LycanitesMobs.modInfo));
        }
    }

    public static void createVanillaLists() {
        ObjectLists.addItem("diet_carnivore", Items.field_151082_bd);
        ObjectLists.addItem("diet_carnivore", Items.field_151147_al);
        ObjectLists.addItem("diet_carnivore", Items.field_151076_bf);
        ObjectLists.addItem("diet_carnivore", Items.field_179558_bo);
        ObjectLists.addItem("diet_carnivore", Items.field_179561_bm);
        ObjectLists.addItem("diet_carnivore", Items.field_151083_be);
        ObjectLists.addItem("diet_carnivore", Items.field_151157_am);
        ObjectLists.addItem("diet_carnivore", Items.field_151077_bg);
        ObjectLists.addItem("diet_carnivore", Items.field_179559_bp);
        ObjectLists.addItem("diet_carnivore", Items.field_179557_bn);
        ObjectLists.addItem("diet_piscivore", Items.field_151115_aP);
        ObjectLists.addItem("diet_piscivore", new ItemStack(Items.field_151115_aP, 1, 1));
        ObjectLists.addItem("diet_piscivore", new ItemStack(Items.field_151115_aP, 1, 2));
        ObjectLists.addItem("diet_piscivore", new ItemStack(Items.field_151115_aP, 1, 3));
        ObjectLists.addItem("diet_piscivore", Items.field_179566_aV);
        ObjectLists.addItem("diet_piscivore", new ItemStack(Items.field_179566_aV, 1, 1));
        ObjectLists.addItem("diet_herbivore", Items.field_151015_O);
        ObjectLists.addItem("diet_herbivore", Items.field_151172_bF);
        ObjectLists.addItem("diet_herbivore", Items.field_151174_bG);
        ObjectLists.addItem("diet_frugivore", Items.field_151034_e);
        ObjectLists.addItem("diet_frugivore", Items.field_151127_ba);
        ObjectLists.addItem("diet_frugivore", Blocks.field_150423_aK);
        ObjectLists.addItem("diet_frugivore", Items.field_151102_aT);
        ObjectLists.addItem("diet_frugivore", new ItemStack(Items.field_151100_aR, 1, 15));
        ObjectLists.addItem("diet_frugivore", Items.field_151106_aX);
        ObjectLists.addItem("diet_frugivore", Blocks.field_150414_aQ);
        ObjectLists.addItem("diet_frugivore", Items.field_151158_bO);
        ObjectLists.addItem("diet_exudativore", new ItemStack(Items.field_151100_aR, 1, 2));
        ObjectLists.addItem("diet_fungivore", Items.field_151009_A);
        ObjectLists.addItem("diet_fungivore", Blocks.field_150337_Q);
        ObjectLists.addItem("diet_fungivore", Blocks.field_150338_P);
        ObjectLists.addItem("diet_fungivore", Blocks.field_150388_bm);
        ObjectLists.addItem("diet_detritivore", Items.field_151078_bh);
        ObjectLists.addItem("diet_detritivore", Items.field_151071_bq);
        ObjectLists.addItem("diet_geovore", Items.field_151044_h);
        ObjectLists.addItem("diet_geovore", new ItemStack(Items.field_151100_aR, 1, 4));
        ObjectLists.addItem("diet_geovore", Items.field_151045_i);
        ObjectLists.addItem("diet_geovore", Items.field_151166_bC);
        ObjectLists.addItem("diet_insectivore", Items.field_151070_bp);
        ObjectLists.addItem("diet_insectivore", Items.field_151071_bq);
        for (String itemListName : itemListNames) {
            ObjectLists.addFromConfig(itemListName.toLowerCase());
        }
        ObjectLists.addEffect("buffs", MobEffects.field_76420_g, "strength");
        ObjectLists.addEffect("buffs", MobEffects.field_76422_e, "haste");
        ObjectLists.addEffect("buffs", MobEffects.field_76426_n, "fire_resistance");
        ObjectLists.addEffect("buffs", MobEffects.field_76432_h, "instant_health");
        ObjectLists.addEffect("buffs", MobEffects.field_76441_p, "invisibility");
        ObjectLists.addEffect("buffs", MobEffects.field_76430_j, "jump_boost");
        ObjectLists.addEffect("buffs", MobEffects.field_76424_c, "speed");
        ObjectLists.addEffect("buffs", MobEffects.field_76439_r, "night_vision");
        ObjectLists.addEffect("buffs", MobEffects.field_76428_l, "regeneration");
        ObjectLists.addEffect("buffs", MobEffects.field_76429_m, "resistance");
        ObjectLists.addEffect("buffs", MobEffects.field_76427_o, "water_breathing");
        ObjectLists.addEffect("buffs", MobEffects.field_180152_w, "health_boost");
        ObjectLists.addEffect("buffs", MobEffects.field_76444_x, "absorption");
        ObjectLists.addEffect("buffs", MobEffects.field_76443_y, "saturation");
        ObjectLists.addEffect("buffs", MobEffects.field_188423_x, "glowing");
        ObjectLists.addEffect("buffs", MobEffects.field_188424_y, "levitation");
        ObjectLists.addEffect("buffs", MobEffects.field_188425_z, "luck");
        ObjectLists.addEffect("debuffs", MobEffects.field_76440_q, "blindness");
        ObjectLists.addEffect("debuffs", MobEffects.field_76431_k, "nausea");
        ObjectLists.addEffect("debuffs", MobEffects.field_76419_f, "mining_fatigue");
        ObjectLists.addEffect("debuffs", MobEffects.field_76433_i, "instant_damage");
        ObjectLists.addEffect("debuffs", MobEffects.field_76438_s, "hunger");
        ObjectLists.addEffect("debuffs", MobEffects.field_76421_d, "slowness");
        ObjectLists.addEffect("debuffs", MobEffects.field_76436_u, "poison");
        ObjectLists.addEffect("debuffs", MobEffects.field_76437_t, "weakness");
        ObjectLists.addEffect("debuffs", MobEffects.field_82731_v, "wither");
        ObjectLists.addEffect("debuffs", MobEffects.field_189112_A, "unluck");
    }

    public static void addFromConfig(String listName) {
        ConfigBase config = ConfigBase.getConfig(LycanitesMobs.modInfo, "itemlists");
        config.setCategoryComment("item lists", "Here you can add items from vanilla Minecraft or other mods to various lists used by this mod. These are mostly food items that can be fed to farmable/tameable mobs. Format is: mod:itemname,metadata Multiple entries should be semicolon separated, be sure to use a colon and semicolon in the correct place.");
        String customDropsString = config.getString("Item Lists", listName).replace(" ", "");
        LycanitesMobs.logDebug("ItemSetup", "~O========== Custom " + listName + " ==========O~");
        if (customDropsString != null && customDropsString.length() > 0) {
            for (String customDropEntryString : customDropsString.replace(" ", "").split(";")) {
                LycanitesMobs.logDebug("ItemSetup", "Adding: " + customDropEntryString);
                String[] customDropValues = customDropEntryString.split(",");
                String dropName = customDropValues[0];
                int dropMeta = 0;
                if (customDropValues.length > 1) {
                    dropMeta = Integer.parseInt(customDropValues[1]);
                }
                if (Item.func_111206_d((String)dropName) != null) {
                    Item customItem = Item.func_111206_d((String)dropName);
                    ObjectLists.addItem(listName, new ItemStack(customItem, 1, dropMeta));
                    LycanitesMobs.logDebug("ItemSetup", "As Item: " + customItem);
                    continue;
                }
                if (Block.func_149684_b((String)dropName) == null) continue;
                Block customBlock = Block.func_149684_b((String)dropName);
                ObjectLists.addItem(listName, new ItemStack(customBlock, 1, dropMeta));
                LycanitesMobs.logDebug("ItemSetup", "As Block: " + customBlock);
            }
        }
    }

    public static boolean isPickaxe(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        try {
            String[] toolNameParts = itemStack.func_77977_a().split("\\.");
            if (toolNameParts.length >= 3 && "InfiTool".equalsIgnoreCase(toolNameParts[1])) {
                String toolName = toolNameParts[2];
                return "Pickaxe".equalsIgnoreCase(toolName) || "Hammer".equalsIgnoreCase(toolName);
            }
            if (itemStack.func_77973_b() instanceof ItemPickaxe) {
                return true;
            }
            if (itemStack.func_77973_b().getHarvestLevel(itemStack, "pickaxe", null, null) != -1) {
                return true;
            }
            return itemStack.func_150997_a(Blocks.field_150348_b.func_176223_P()) > 1.0f;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isAxe(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        try {
            String[] toolNameParts;
            for (String toolNamePart : toolNameParts = itemStack.func_77977_a().split("\\.")) {
                if (toolNameParts.length < 3 || !"InfiTool".equalsIgnoreCase(toolNameParts[1])) continue;
                String toolName = toolNameParts[2];
                return "Axe".equalsIgnoreCase(toolName) || "LumberAxe".equalsIgnoreCase(toolName) || "Mattock".equalsIgnoreCase(toolName) || "Battleaxe".equalsIgnoreCase(toolName);
            }
            if (itemStack.func_77973_b() instanceof ItemAxe) {
                return true;
            }
            if (itemStack.func_77973_b().getHarvestLevel(itemStack, "axe", null, null) != -1) {
                return true;
            }
            return itemStack.func_150997_a(Blocks.field_150364_r.func_176223_P()) > 1.0f;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isShovel(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        try {
            String[] toolNameParts = itemStack.func_77977_a().split("\\.");
            if (toolNameParts.length >= 3 && "InfiTool".equalsIgnoreCase(toolNameParts[1])) {
                String toolName = toolNameParts[2];
                return "Shovel".equalsIgnoreCase(toolName) || "Excavator".equalsIgnoreCase(toolName) || "Mattock".equalsIgnoreCase(toolName);
            }
            if (itemStack.func_77973_b() instanceof ItemSpade) {
                return true;
            }
            if (itemStack.func_77973_b().getHarvestLevel(itemStack, "shovel", null, null) != -1) {
                return true;
            }
            return itemStack.func_150997_a(Blocks.field_150346_d.func_176223_P()) > 1.0f;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isName(Item item, String name) {
        if (item == null) {
            return false;
        }
        String itemName = item.func_77658_a().toLowerCase();
        return itemName.contains(name);
    }

    public static boolean isName(Block block, String name) {
        if (block == null) {
            return false;
        }
        name = name.toLowerCase();
        String blockName = block.func_149739_a().toLowerCase();
        return blockName.contains(name);
    }
}

